<?

class path_input {

	public $path = NULL;

	private $original_path = NULL;

	public function __construct($path) {
		$this->path = $path;
		$this->original_path = $path;
	}

	public function make_accessible($callback=NULL) {
		$self = $this;
		if(!$files->is_readable($this->path)) {
			$files->picker($this->path, true, false, function($url) {
				if(!$files->is_readable($self->path)) {
					$self->make_accessible($callback);
				} else {
					if($callback != NULL) {
						$callback();
					}
				}
			});
		} else {
			if($callback != NULL) {
				$callback();
			}
		}
	}

	public $is_incomplete = false;

	public $incomplete_component = NULL;

	public function get_is_incomplete() {
		return $this->is_incomplete;
	}

	public function get_results() {
		$self = $this;
		$exists = $files->exists($this->path);
		$is_dir = $files->is_dir($this->path);
		if(!$exists && $object->strings->strlen($this->path) > 0) {
			$this->path = $files->remove_path_component($this->path);
			$split_value = $object->strings->split($this->original_path, $this->path);
			if($split_value->length < 2 || $object->strings->strlen($split_value[1]) == 0) {
				$this->invalidate_progress();
				return ['result' => false];
			}
			$split_value_item = $split_value[1];
			$this->incomplete_component = $split_value_item;
			if($object->strings->strpos($split_value_item, '/') === 0) {
				$this->incomplete_component = $object->strings->substr($split_value_item, 1);
			}
			$this->is_incomplete = true;
			$exists = $files->exists($this->path);
			$is_dir = $files->is_dir($this->path);
		}
		if($object->strings->strlen($this->path) === 0) {
			$this->invalidate_progress();
			return ['result' => false];
		}
		if($exists && $is_dir) {
			$this->make_accessible(function() {
				$list_dirs_wrap = async function($path, $incomplete) {
					$directories_instance = new directories($path, $incomplete);

					if($self->is_incomplete) {
						$directories_instance->get_list();
					} else {
						$directories_instance->sub_directories();	
					}
				};
				$list_dirs_wrap($self->path, $self->incomplete_component);
			});
		} else {
			$this->invalidate_progress();
		}
		if($self->is_incomplete) {
			return ['result' => false];
		}
		$last_component = '';
		$original_path = $this->original_path;
		if($object->strings->strlen($original_path) > 0) {
			$without_last_component = $files->remove_path_component($original_path); 
			$last_component = $object->strings->split($original_path, $without_last_component);
			if($last_component->length > 1) {
				$last_component = $last_component[1];
				$last_component_split = $object->strings->split($last_component, '/');
				foreach($last_component_split as $split_value) {
					if($object->strings->strlen($split_value) > 0) {
						$last_component = $split_value;
					}
				}
			}
		}
		return [
			'result' => true, 
			'directory' => [
				'fullpath' => $original_path,
				'last_component' => $last_component
			]
		];
	}

	private function invalidate_progress() {
		$object->send('app.locations.invalidate_progress();', [
			'data' => []
		]);
	}

}

class directories {

	private $path;

	private $incomplete_component;

	public function __construct($path, $incomplete_component) {
		$this->path = $path;
		$this->incomplete_component = $incomplete_component;
	}

	public function sub_directories() {
		$results = [];
		$immediate_sub_items = $files->list_files($this->path);
		foreach($immediate_sub_items as $sub_item) {
			$sub_item_fullpath = $files->append_path($this->path, $sub_item);
			$sub_item_object = [
				'fullpath' => $sub_item_fullpath,
				'last_component' => $sub_item
			];
			if($files->is_dir($sub_item_fullpath)) {
				$results[] = $sub_item_object;
			}
		}

		$object->send('app.locations.display_path_completions(data);', [
			'data' => $results
		]);
	}

	public function get_list() {
		$results = [];
		$incomplete_lower = $object->strings->lower($this->incomplete_component);
		$immediate_sub_items = $files->list_files($this->path);
		foreach($immediate_sub_items as $sub_item) {
			$sub_item_fullpath = $files->append_path($this->path, $sub_item);
			$sub_item_object = [
				'fullpath' => $sub_item_fullpath,
				'last_component' => $sub_item
			];
			if($files->is_dir($sub_item_fullpath) && $object->strings->strpos($object->strings->lower($sub_item), $incomplete_lower) === 0) {
				$results[] = $sub_item_object;
			}
		}
		$object->send('app.locations.display_path_completions(data);', [
			'data' => $results
		]);
	}
}

?>